/*
 * Decompiled with CFR 0.152.
 */
package andrews.online_detector.network.server;

import andrews.online_detector.block_entities.AdvancedOnlineDetectorBlockEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerSelectPlayer {
    private final BlockPos pos;
    private final UUID uuid;
    private final String name;

    public MessageServerSelectPlayer(BlockPos pos, UUID uuid, String name) {
        this.pos = pos;
        this.uuid = uuid;
        this.name = name;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130077_(this.uuid);
        buf.m_130070_(this.name);
    }

    public static MessageServerSelectPlayer deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        UUID uuid = buf.m_130259_();
        String name = buf.m_130136_(Short.MAX_VALUE);
        return new MessageServerSelectPlayer(pos, uuid, name);
    }

    public static void handle(MessageServerSelectPlayer message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_183503_();
        BlockPos blockEntityPos = message.pos;
        UUID uuid = message.uuid;
        String name = message.name;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity blockEntity;
                if (level != null && (blockEntity = level.m_7702_(blockEntityPos)) instanceof AdvancedOnlineDetectorBlockEntity) {
                    AdvancedOnlineDetectorBlockEntity advancedOnlineDetectorBlockEntity = (AdvancedOnlineDetectorBlockEntity)blockEntity;
                    advancedOnlineDetectorBlockEntity.setOwnerUUID(uuid);
                    advancedOnlineDetectorBlockEntity.setOwnerName(name);
                    level.m_7260_(message.pos, level.m_8055_(blockEntityPos), level.m_8055_(blockEntityPos), 2);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

